VERSION 5.00
Object = "{5EB78BCC-023B-11D4-9AA7-0080ADC7FBD4}#1.1#0"; "ucNumBox.ocx"
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmDetallesMedio 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Detalles del pago"
   ClientHeight    =   2985
   ClientLeft      =   6750
   ClientTop       =   3510
   ClientWidth     =   10005
   ControlBox      =   0   'False
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2985
   ScaleWidth      =   10005
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin ucNumero.ucNumBox numCantidad 
      Height          =   315
      Left            =   5940
      TabIndex        =   16
      Tag             =   "GED_Cantidad"
      Top             =   960
      Visible         =   0   'False
      Width           =   765
      _ExtentX        =   1349
      _ExtentY        =   556
      Formato         =   "#,##0"
      Enabled         =   -1  'True
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ucNumero.ucNumBox numDenominacion 
      Height          =   315
      Left            =   4830
      TabIndex        =   15
      Tag             =   "GED_Denominacion"
      Top             =   960
      Visible         =   0   'False
      Width           =   1125
      _ExtentX        =   1984
      _ExtentY        =   556
      Enabled         =   -1  'True
      ShowCalc        =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.CommandButton cbCancelar 
      Cancel          =   -1  'True
      Caption         =   "Cancelar (Esc)"
      CausesValidation=   0   'False
      Height          =   525
      Left            =   8310
      TabIndex        =   18
      Top             =   2070
      Width           =   1635
   End
   Begin VB.CommandButton cbOk 
      Caption         =   "Aceptar (O&k)"
      Height          =   525
      Left            =   8280
      TabIndex        =   17
      Top             =   1500
      Width           =   1635
   End
   Begin MSComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   345
      Left            =   0
      TabIndex        =   19
      Top             =   2640
      Width           =   10005
      _ExtentX        =   17648
      _ExtentY        =   609
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   1
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   17119
         EndProperty
      EndProperty
   End
   Begin VB.Frame Frame1 
      Caption         =   "Detalles del emisor/titular"
      Height          =   2595
      Left            =   60
      TabIndex        =   0
      Top             =   30
      Width           =   4665
      Begin ucNumero.ucNumBox numMontoRecibido 
         Height          =   315
         Left            =   2160
         TabIndex        =   12
         Top             =   2130
         Width           =   1965
         _ExtentX        =   3466
         _ExtentY        =   556
         Enabled         =   -1  'True
         ShowCalc        =   -1  'True
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
      End
      Begin VB.ComboBox cbxEmisor 
         Height          =   315
         Left            =   2160
         TabIndex        =   10
         Top             =   1740
         Width           =   1995
      End
      Begin VB.TextBox txClaveAutorizacion 
         Height          =   315
         Left            =   2160
         MaxLength       =   14
         TabIndex        =   8
         Top             =   1380
         Width           =   2385
      End
      Begin VB.TextBox txNumDoc 
         Height          =   315
         Left            =   2160
         MaxLength       =   14
         TabIndex        =   6
         Top             =   1020
         Width           =   2385
      End
      Begin VB.TextBox txCuenta 
         Height          =   315
         Left            =   2160
         MaxLength       =   20
         TabIndex        =   4
         Top             =   660
         Width           =   2385
      End
      Begin VB.TextBox txIdTitular 
         Height          =   315
         Left            =   2160
         MaxLength       =   14
         TabIndex        =   2
         Top             =   300
         Width           =   2385
      End
      Begin VB.Label lblMontoRecibido 
         AutoSize        =   -1  'True
         Caption         =   "Monto recibido:"
         Height          =   195
         Left            =   150
         TabIndex        =   11
         Top             =   2190
         Width           =   1095
      End
      Begin VB.Label lblCodigoEmisor 
         AutoSize        =   -1  'True
         Caption         =   "Cdigo de emisor:"
         Height          =   195
         Left            =   150
         TabIndex        =   9
         Top             =   1800
         Width           =   1260
      End
      Begin VB.Label lblClaveAuth 
         AutoSize        =   -1  'True
         Caption         =   "Clave de autorizacin:"
         Height          =   195
         Left            =   150
         TabIndex        =   7
         Top             =   1410
         Width           =   1575
      End
      Begin VB.Label lblComprobante 
         AutoSize        =   -1  'True
         Caption         =   "Numero de comprobante:"
         Height          =   195
         Left            =   150
         TabIndex        =   5
         Top             =   1050
         Width           =   1800
      End
      Begin VB.Label lblCuenta 
         AutoSize        =   -1  'True
         Caption         =   "Numero de Cuenta:"
         Height          =   195
         Left            =   150
         TabIndex        =   3
         Top             =   690
         Width           =   1380
      End
      Begin VB.Label lblIdTitular 
         AutoSize        =   -1  'True
         Caption         =   "ID del Titular:"
         Height          =   195
         Left            =   150
         TabIndex        =   1
         Top             =   330
         Width           =   945
      End
   End
   Begin MSFlexGridLib.MSFlexGrid flxDenominaciones 
      Height          =   2265
      Left            =   4770
      TabIndex        =   14
      Top             =   330
      Width           =   3465
      _ExtentX        =   6112
      _ExtentY        =   3995
      _Version        =   393216
      Cols            =   3
      FixedCols       =   0
      RowHeightMin    =   285
      FormatString    =   "Denominacion|>Cantidad|>Monto total        "
   End
   Begin VB.Label lblDetallesDenominacion 
      AutoSize        =   -1  'True
      Caption         =   "Detalles de Denominacin"
      Height          =   195
      Left            =   4800
      TabIndex        =   13
      Top             =   60
      Width           =   1860
   End
End
Attribute VB_Name = "frmDetallesMedio"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Detalle As CDetalleIngreso
Private bResult As Boolean
Private geditor As GEDObject
Private TipoCambio As Double

Private Sub ActualizarMonto()
Dim Total As Currency, i As Long
  
  With flxDenominaciones
    Total = 0
    For i = .FixedRows To .Rows - 1
      Total = Total + ValOf(.TextMatrix(i, 2))
    Next
  End With
  
  Me.numMontoRecibido.Value = Total

End Sub

Private Function LlenarResultado() As Boolean
  With Detalle
    Set .Denominaciones = New Collection
    With flxDenominaciones
      If .Visible Then
        Dim i As Long
        For i = .FixedRows To .Rows - 1
          If IsRowValid(i) Then
            Dim cDetalleDenom As CDetalleDenominacion
            Set cDetalleDenom = New CDetalleDenominacion
            cDetalleDenom.Denominacion = ValOf(.TextMatrix(i, 0))
            cDetalleDenom.CantidadRecibida = ValOf(.TextMatrix(i, 1))
            Detalle.Denominaciones.Add cDetalleDenom
          Else
            LlenarResultado = False
            Exit Function
          End If
        Next
      End If
    End With
    If Me.txClaveAutorizacion.Enabled Then
      .ClaveAutorizacion = Me.txClaveAutorizacion.Text
      If .ClaveAutorizacion = "" Then
        mAdvertencia "Clave de autorizacion invlida"
        txClaveAutorizacion.SetFocus
        LlenarResultado = False
        Exit Function
      End If
    End If
    If Me.cbxEmisor.Enabled Then
      .CodigoEmisor = Me.cbxEmisor.Text
      If .CodigoEmisor = "" Then
        mAdvertencia "Codigo de emisor invlido"
        cbxEmisor.SetFocus
        LlenarResultado = False
        Exit Function
      End If
    End If
    If txIdTitular.Enabled Then
      .IdTitular = Me.txIdTitular.Text
      If .IdTitular = "" Then
        mAdvertencia "Identificacion invlida"
        txIdTitular.SetFocus
        LlenarResultado = False
        Exit Function
      End If
    End If
    
    .MontoNominal = Me.numMontoRecibido.Value
    .Monto = .MontoNominal * TipoCambio
    If .Monto <= 0 Then
      mAdvertencia "Monto invlido"
      LlenarResultado = False
      Exit Function
    End If
    
    If txCuenta.Enabled Then
      .NumeroCuenta = Me.txCuenta.Text
      If .NumeroCuenta = "" Then
        mAdvertencia "Numero de cuenta invlido"
        txCuenta.SetFocus
        LlenarResultado = False
        Exit Function
      End If
    End If
    
    If txNumDoc.Enabled Then
      .NumeroDocumento = Me.txNumDoc.Text
      If .ClaveAutorizacion = "" Then
        mAdvertencia "Numero de documento invlido"
        txNumDoc.SetFocus
        LlenarResultado = False
        Exit Function
      End If
    End If
  End With
  LlenarResultado = True
End Function

Private Sub SetStatus(s As String)
  StatusBar1.Panels(1).Text = s
End Sub

Public Function EditDetalle(pDetalle As CDetalleIngreso) As Boolean
  Load Me
  Set Detalle = pDetalle
  If Not Config Then
    EditDetalle = False
    Exit Function
  End If
  Me.Show vbModal
  EditDetalle = bResult
  Unload Me
End Function

Private Function LoadDenominaciones()
  With flxDenominaciones
    Dim n As Long
    .Rows = .FixedRows + Detalle.Denominaciones.Count
    Dim pDetalle As CDetalleDenominacion
    For Each pDetalle In Detalle.Denominaciones
      .TextMatrix(n, 0) = Format(pDetalle.Denominacion, "#,##0.00")
      .TextMatrix(n, 1) = Format(pDetalle.CantidadRecibida, "#,##0")
      .TextMatrix(n, 2) = Format(pDetalle.Valor, "#,##0.00")
      n = n + 1
    Next
    If .Rows = .FixedRows Then .Rows = .FixedRows + 1
  End With
End Function

Private Function Config() As Boolean
Dim Medio As New CMedioPago
  
  If Not Medio.Load(Detalle.Medio) Then
    mAdvertencia "ERROR: Medio de pago desconocido (" & Detalle.Medio & ")"
    Config = False
    Exit Function
  End If
  ' Despacha el control de denominaciones
  If Medio.Atributos And ControlDenominaciones Then
    Me.numMontoRecibido.Enabled = False
    Me.numMontoRecibido.TabStop = False
    Me.flxDenominaciones.Enabled = True
    Set geditor = New GEDObject
    With geditor
    .init Me, flxDenominaciones
    .AddControl 0, Me.numDenominacion
    .AddControl 1, Me.numCantidad
    End With
    LoadDenominaciones
  Else
    lblDetallesDenominacion.Visible = False
    Me.numMontoRecibido.Enabled = True
    Me.numMontoRecibido.TabStop = True
    cbOk.left = flxDenominaciones.left
    cbCancelar.left = flxDenominaciones.left
    flxDenominaciones.Visible = False
    Me.Width = cbOk.left + 1815
    Centrar Me
  End If
  
  With txCuenta
  .Enabled = (Medio.Atributos And ControlIDCuenta) <> 0
  .TabStop = .Enabled
  .Text = Detalle.NumeroCuenta
  End With

  With txIdTitular
  .Enabled = (Medio.Atributos And ControlIDTitular) <> 0
  .TabStop = .Enabled
  .Text = Detalle.IdTitular
  End With

  With txNumDoc
  .Enabled = (Medio.Atributos And ControlNumero) <> 0
  .TabStop = .Enabled
  .Text = Detalle.NumeroDocumento
  End With

  With txClaveAutorizacion
  .Enabled = (Medio.Atributos And ControlClaveAutorizacion) <> 0
  .TabStop = .Enabled
  .Text = Detalle.ClaveAutorizacion
  End With

  With cbxEmisor
    .Enabled = (Medio.Atributos And ControlEmisor) <> 0
    .TabStop = .Enabled
    If .Enabled Then
      Dim rs As Recordset
      Set rs = dbHandle.Execute("SELECT DISTINCT Emisor FROM DetallesIngresoCaja WHERE Medio = " & StringDB(Medio.Codigo) & " ORDER BY Emisor")
      Do While Not rs.EOF
        .AddItem rs(0)
        rs.MoveNext
      Loop
      rs.Close
    End If
    .Text = Detalle.CodigoEmisor
  End With
  
  If Medio.Atributos And MonedaExtranjera Then
    TipoCambio = Medio.TipoCambio
  Else
    TipoCambio = 1
  End If
  
  numMontoRecibido.Value = Detalle.MontoNominal
  
  Config = True
End Function

Private Sub cbCancelar_Click()
  bResult = False
  Me.Hide
End Sub

Private Sub cbOk_Click()
  If LlenarResultado Then
    bResult = True
    Me.Hide
  End If
End Sub

Private Sub cbxEmisor_GotFocus()
  SetStatus "Seleccione el codigo del ente emisor del valor"
End Sub

Private Sub cbxEmisor_Validate(Cancel As Boolean)
  If Not Detalle.ExisteEmisor(cbxEmisor.Text) Then
    If Not Confirmar("No existen registros previos de ese emisor" & vbCrLf & "Es correcto el cdigo?") Then
      Cancel = False
      Exit Sub
    End If
  End If
End Sub

Private Sub flxDenominaciones_Scroll()
  geditor.Scroll
End Sub

Private Sub flxDenominaciones_GotFocus()
  geditor.EnterCell
End Sub

Private Sub flxDenominaciones_EnterCell()
  geditor.EnterCell
End Sub

Public Function ValidateCell(nRow As Long, nCol As Long) As Boolean
  With flxDenominaciones
    Select Case nCol
    Case 0
      If ValOf(.TextMatrix(nRow, 0)) <= 0 Then
        mAdvertencia "Por favor, indique una cantidad positiva"
        ValidateCell = False
        Exit Function
      End If
    Case 1
      If ValOf(.TextMatrix(nRow, 1)) <= 0 Then
        mAdvertencia "Por favor, introduzca un valor positivo"
        ValidateCell = False
        Exit Function
      End If
    End Select
    .TextMatrix(nRow, 2) = Format(ValOf(.TextMatrix(nRow, 0)) * ValOf(.TextMatrix(nRow, 1)), "#,##0.00")
  End With
  ActualizarMonto
  ValidateCell = True
End Function

Public Function IsRowValid(nRow As Long) As Boolean
  With flxDenominaciones
    If ValOf(.TextMatrix(nRow, 0)) <= 0 Then
      mAdvertencia "Por favor, indique una cantidad positiva"
      IsRowValid = False
      Exit Function
    End If
    
    If ValOf(.TextMatrix(nRow, 1)) <= 0 Then
      mAdvertencia "Por favor, introduzca un valor positivo"
      IsRowValid = False
      Exit Function
    End If
  End With
  IsRowValid = True
End Function

Public Function MayAddRow(nRows As Long) As Boolean
  MayAddRow = True
End Function

Public Function MayDeleteRow(nRow As Long) As Boolean
  With flxDenominaciones
    .TextMatrix(nRow, 0) = "0"
    .TextMatrix(nRow, 1) = "0"
  End With
  ActualizarMonto
  MayDeleteRow = True
End Function

Public Sub FillNewRow(nRow As Long)

End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
    TranslateReturn KeyAscii, Me.ActiveControl
End Sub

Private Sub numCantidad_GotFocus()
  SetStatus "Cantidad de unidades recibidas de la denominacion seleccionada"
End Sub

Private Sub numDenominacion_LostFocus()
  geditor.ControlLost
End Sub

Private Sub numDenominacion_KeyDown(KeyCode As Integer, Shift As Integer)
  geditor.KeyDown KeyCode, Shift
End Sub

Private Sub numDenominacion_GotFocus()
  SetStatus "Denominacin (valor unitario) de los valores recibidos"
End Sub

Private Sub numCantidad_LostFocus()
  geditor.ControlLost
End Sub

Private Sub numCantidad_KeyDown(KeyCode As Integer, Shift As Integer)
  geditor.KeyDown KeyCode, Shift
End Sub

Private Sub numMontoRecibido_GotFocus()
  SetStatus "Monto recibido"
End Sub

Private Sub numMontoRecibido_Validate(Cancel As Boolean)
  If numMontoRecibido.Enabled And numMontoRecibido.Value <= 0 Then
    mAdvertencia "Por favor, escriba un valor positivo"
    Cancel = True
    Exit Sub
  End If
End Sub

Private Sub txClaveAutorizacion_GotFocus()
  SetStatus "Clave de autorizacin del banco u operador de crdito"
End Sub

Private Sub txClaveAutorizacion_Validate(Cancel As Boolean)
  txClaveAutorizacion.Text = Trim(UCase(txClaveAutorizacion.Text))
  If Len(txClaveAutorizacion.Text) < 4 Or Len(txClaveAutorizacion.Text) > 6 Then
    mAdvertencia "La clave debe contener de cuatro a seis caracteres"
    Cancel = True
    Exit Sub
  End If
End Sub

Private Sub txCuenta_GotFocus()
  SetStatus "Numero de la cuenta"
End Sub

Private Sub txCuenta_Validate(Cancel As Boolean)
  txCuenta.Text = UCase(Trim(txCuenta.Text))
  If Len(txCuenta.Text) < 8 Or Len(txCuenta.Text) > 20 Then
    mAdvertencia "El numero de cuenta debe tener de ocho a veinte caracteres"
    Cancel = True
    Exit Sub
  End If
End Sub

Private Sub txIdTitular_GotFocus()
  SetStatus "Documento de identidad del titular"
End Sub

Private Sub txIdTitular_Validate(Cancel As Boolean)
  txIdTitular.Text = UCase(Trim(txIdTitular.Text))
  If Len(txIdTitular.Text) < 6 Or Len(txIdTitular.Text) > 15 Then
    mAdvertencia "La identificacion debe tener de seis a quince caracteres"
    Cancel = True
    Exit Sub
  End If
End Sub

Private Sub txNumDoc_GotFocus()
  SetStatus "Numero del cheque, voucher o transaccin"
End Sub

Private Sub txNumDoc_Validate(Cancel As Boolean)
  txNumDoc.Text = UCase(Trim(txNumDoc.Text))
  If Len(txNumDoc.Text) < 6 Or Len(txNumDoc.Text) > 20 Then
    mAdvertencia "El nmero del documento debe tener de seis a veinte caracteres"
    Cancel = True
    Exit Sub
  End If
End Sub
